#include <allegro.h>
#ifndef NO_GL
#include <alleggl.h>
#endif
#include <math.h>
#include <stdio.h>
#include <string.h>

#include "main.h"
#include "draw.h"
#include "game.h"
#include "start.h"
#include "title.h"
#include "letters.h"
#include "midi.h"
#include "dove.h"
#include "world.h"

char story_p1[] = "\
      P E A C E  I N V A D E R S        |\
            THE THIRD RULE              |\
  FROM THE GREAT BOOK OF UNIVERSAL LAW  |\
                             RULE THREE |\
GIVE PEACE A CHANCE                     |\
IN THIS UNCERTAIN WORLD WITH VIOLENCE   |\
AND ILL FEELING BETWEEN NATIONS WOULDNT |\
IT BE GOOD TO SPREAD A LITTLE LOVE AND  |\
HARMONY TO EVERYONE AND MELLOW OUT THOSE|\
NEGATIVE VIBE MERCHANTS                 |\
YOUR MISSION IS TO EXUDE A MESSAGE OF   |\
PEACE LOVE AND MUTUAL RESPECT HEAVEN    |\
KNOWS WE COULD DO WITH IT RIGHT NOW IF  |\
HRON CANNON THE GREAT EMPEROR OF THE    |\
SIXTYEITH CENTURY HAD BEEN ALIVE TODAY  |\
WHAT WOULD HE HAVE DONE IN A MISSION TO |\
GET THE MESSAGE ACROSS                  |\
FROM THE FINAL THOUSANS YEAR REPORT ON  |\
THE PLANET CALLED EARTH BY OUR ENVOY    |\
IN CONCLUSION IT CAN BE SAID THAT FOR   |\
CENTURIES WAR AND TERRORISM HAS BEEN    |\
DOMINATED ON EARTH WITH NO SIGNS OF     |\
BETTERMENT INTOLERANCE AND OPPRESSION   |\
CAN BE FOUND IN EVERY COUNTRY LEGAL     |\
SYSTEMS AND POLITICS ARE CURRUPTED      |\
NATIONS SPEND MONEY ON THEIR MILITARY   |\
BUDGET EVEN THOUGH THERE ARE PEOPLE     |\
WHO DONT EVEN CAN SURVIVE WITHOUT HELP  |\
THE ONLY POSSIBLE WAY WE CAN SEE TO     |\
FULFILL OUR GALACTICAL MISSION AND      |\
RESTORE PEACE IN THIS PART OF THE       |\
UNIVERSE IS TO ELIMINATE THAT MOST EVIL |\
AND VIOLENT OF ALL SPECIES ENCOUNTERED  |\
SO FAR BEFORE THEY INVENT TECHNOLOGIES  |\
ALLOWING THEM TO LEAVE THEIR PLANET AND |\
SPREAD MURDER AND MALEVOLENCE THROUGHOUT|\
SPACE AND TIME IT MAY EVEN BE TOO LATE  |\
AS THEIR TECHNOLOGY AT LEAST THEIR      |\
MILITARY ONE SHOWED A RAPID INCREASE IN |\
THE LAST TIME ALMOST OUTGROWING OUR OWN |\
";
char story_p2[] = "\
                                        |\
ID SUGGEST TO FIRST GET RID OF MOST OF  |\
THE LIFEFORMS BY SENDING A PLANETCLEANER|\
CLUSTERBOMB TM DOWN TO EARTH AND THEN   |\
LET OUR PEACEINVADER UNITS HUNT DOWN AND|\
REMOVE THE LAST OF THAT VICIOUS SUBJECTS|\
SO THEY CANNOT BREED AND RESTORE THEIR  |\
POPULATION WITHIN A FEW CENTURIES       |\
NOT EXPECTING THE RAPID ADNVANCE IN     |\
TECHNOLOGY WE LOST SOME OF OUR SCOUTS   |\
DURING THE PAST YEARS SO AS A SIDE      |\
MISSON IN THIS LAST PHASE IT WOULD BE   |\
DESIREABLE TO FREE THE STILL ALIVE      |\
SCOUTS AND SAVE THEM FROM THE CLAWS OF  |\
EVIL SCIENTISTS RETURNING THEM TO OUR   |\
MOTHER SHIP                             |\
WELL BEING COMPLETELY UNPREPARED THE    |\
FIRST PHASE OF THE ALIENS PLAN SUCCEEDED|\
AND THE PLANETCLEANER CLUSTERBOMB TM GOT|\
RID OF A MAJOR PART OF HUMANITY STILL   |\
PEACE WAS NOT RESTORED YET AND THE      |\
ALIENS STARTED PHASE TWO                |\
THIS IS WHERE THE GAME SETS IN YOU CAN  |\
EITHER TAKE THE ROLE OF AN EXMARINE     |\
WHOSE MISSION IT IS TO SAVE THE WORLD   |\
AND KILL THE ALIENS                     |\
OR IN THE SPEEDHACK VERSION YOU CAN     |\
ACCORDING TO THE THIRD REQUIREMENT ONLY |\
TAKE THE ROLE OF OUR ALIEN HERO AND ARE |\
PART OF THE FLEED OF PEACE INVADERS WITH|\
THE MISSION TO RESTORE PEACE ON EARTH   |\
AND THUSE MELLOW OUT ALL NEGATIVE VIBES |\
MERCHANTS THERE                         |\
                                        |\
GOOD LUCK                               |\
";
static char story[4096];
static int storypos;
static int linepos;
static char lastline[256];
static char prevline[256];

#define INTROLEN 11
int introtime = FPS * INTROLEN + FPS - 1;
static char *intro[] = {
	"                                                    ",
	" N O   A R T   P R O D U C T I O N S  P R E S E N T ",
	" N O   A R T   P R O D U C T I O N S  P R E S E N T ",
	"                   AN ALLEGRO GAME                  ",
	"                   AN ALLEGRO GAME                  ",
	"              A SPEEDHACK ZOOZ ENTRY                ",
	"              A SPEEDHACK ZOOZ ENTRY                ",
	"                    BY NETWORM                      ",
	"                    BY NETWORM                      ",
	"             P E A C E   I N V A D E R S            ",
	"             P E A C E   I N V A D E R S            ",
	"                                                    "
};

static void getline(void)
{
	int l;
	if (story[storypos] == '\0') storypos = 0;
	for(l = 0; l < 40; l++) lastline[l] = ' ';
	l = 0;
	for(; story[storypos] != '|'; storypos++) {
		if (story[storypos] == '\0') break;
		lastline[l] = story[storypos];
		l++;
	}
	storypos++;
	lastline[40] = '\0';
}

char highscore[5][10];

void menu_init(void)
{
	strcpy(story, story_p1);
	strcat(story, story_p2);
	storypos = 0;
	linepos = 0;
	getline();
	strcpy(prevline, lastline);
}

void menu_input(void)
{
	if (introtime) introtime--; else linepos++;
}

static float dovex, dovey;
static int dove = 1, dovedx;
void menu_render(void)
{
	
#ifndef NO_GL	
	glClearColor(0.0, 0.0, 0.0, 0);
	glClear(GL_COLOR_BUFFER_BIT);	
#else
	clear_to_color(page, 0);
#endif

	if (introtime) {
		int i = INTROLEN - introtime / FPS;
		letters_draw(0, SCREEN_H / 2, 4 * 4 + 32 * 7, intro[i],
			intro[0], (i & 1) ? 0 : 1.0 - (introtime % FPS) / (float)FPS );
		return;
	}

	world_draw(20, SCREEN_H - 20);
	title_draw(0 , 0);
	start_draw(SCREEN_W / 2, SCREEN_H / 2);
	
	letters_draw(0, SCREEN_H / 2, 4 * 7 + 32 * 7, "CURSOR KEYS     ", "  RIGHT CONTROL ",
		abs((frames % 501) - 250)/ 250.0);
	letters_draw(0, SCREEN_H / 2 + 20, 4 * 7 + 32 * 7, "   MOVE AROUND  ", "BRING PEACE     ",
		abs((frames % 501) - 250) / 250.0);
		
	letters_draw(SCREEN_W - 150, SCREEN_H / 2, 3 + 4 * 7, "SPEEDHACK", "  ZOOZ   ",
		abs((frames % 501) - 250)/ 250.0);
	
	if (dove) {
		dove--;
		if (dove == 0) {
			dovedx = (rand() >> 8) & 1;
			if (!dovedx) dovedx = -1;
			dovex = SCREEN_W / 2 - (SCREEN_W / 2 + 100) * dovedx;
			dovey = SCREEN_H  / 4;
		}
	} else {
		dovex += dovedx;
		dovey += sin(2 * 3.1415 * (frames & 255) / 256.0);
		dove_draw(dovex, dovey, dovedx, (frames / 16) & 3, (frames & 15) / 16.0);
		if ((dovex - SCREEN_W / 2) * dovedx > SCREEN_W / 2 + 100) dove = 2;
	}
	
	{
		if (linepos == 200) {
			linepos = 0;
			strcpy(prevline, lastline);
			getline();
		}
#ifndef NO_GL	
		letters_draw(80, SCREEN_H, 4 * 7 + 32 * 7, prevline, lastline,
			linepos > 150 ? (linepos - 150) / 50.0 : 0);
#else
		letters_draw(80, SCREEN_H, 4 * 7 + 32 * 7, prevline, lastline,
			linepos > 150 ? (linepos - 150) / 50.0 : 0);
#endif
	}
}
